# coding: utf8
import datetime
import logger as logger


class PrintLogger(logger.Logger):
    def __init__(self, name=None):
        super(PrintLogger, self).__init__(name)

    def logging(self, section, text):
        print('{}\t{}\t{{{}}}\t{}'.format(
            section, self.name, datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S'), text
        ))
