# coding: utf8
import logger as logger


class ProxyLogger(logger.Logger):
    def __init__(self, name, loggers):
        super(ProxyLogger, self).__init__(name)
        self.loggers = loggers if isinstance(loggers, list) else [loggers]

    def logging(self, section, text):
        for logger_ in self.loggers:
            logger_.logging(section, text)
