# coding: utf8
import sys
import flask
import multiprocessing

import logging_settings  # !!! This file has on import code (singleton settings)
import gencfg_notify_bot as gnb


def async_start_gencfg_notify_bot():
    logging_settings.main_logger.info('Starting gencfg-notify-bot')

    gencfg_notify_bot = gnb.GencfgNotifyBot(scheduler_cycle_delay=10)
    proc = multiprocessing.Process(target=gencfg_notify_bot.start)
    proc.start()

    return proc


def main():
    if len(sys.argv) != 2:
        print('Usage: ./gencfg-notify-bot <port>')
        sys.exit(0)

    gnb_proc = async_start_gencfg_notify_bot()

    logging_settings.main_logger.info('Starting gencfg-notify-bot web')

    app = flask.Flask(__name__)
    app.run(host='::', port=int(sys.argv[1]), use_reloader=False, debug=True)

    logging_settings.main_logger.info('Finished gencfg-notify-bot web')

    logging_settings.main_logger.info('Terminating gencfg-notify-bot')

    gnb_proc.terminate()

    logging_settings.main_logger.info('Terminated gencfg-notify-bot')


if __name__ == '__main__':
    main()
