# coding: utf8
import pymongo

import collections


MongoStorage = collections.namedtuple('MongoStorage', ['uri', 'replicaset'])

HEARTBEAT_C = MongoStorage(
    uri=','.join([
        'myt0-4012.search.yandex.net:27017',
        'myt0-4019.search.yandex.net:27017',
        'sas1-6063.search.yandex.net:27017',
        'sas1-6136.search.yandex.net:27017',
        'vla1-3984.search.yandex.net:27017',
    ]),
    replicaset='heartbeat_mongodb_c'
)

HEARTBEAT_D = MongoStorage(
    uri=','.join([
        'myt0-4013.search.yandex.net:27017',
        'myt0-4020.search.yandex.net:27017',
        'sas4-4916.search.yandex.net:27017',
        'sas4-4917.search.yandex.net:27017',
        'vla1-6006.search.yandex.net:27017',
    ]),
    replicaset='heartbeat_mongodb_d'
)

HEARTBEAT_DEFAULT = HEARTBEAT_C


def get_collection(heartbeat, db_name, collection_name):
    return pymongo.MongoReplicaSetClient(
        heartbeat.uri,
        connectTimeoutMS=15000,
        replicaSet=heartbeat.replicaset,
        w='majority',
        wtimeout=15000,
    )[db_name][collection_name]


def find_one(collection, query, sort_key='_id', sort_value=1):
    sort_key = sort_key or '_id'
    sort_value = sort_value or 1
    requests = collection.find(query).sort(sort_key, sort_value).limit(1)
    request = requests[0] if requests.count() else None
    return request


def find_all(collection, query, sort_key='_id', sort_value=1, limit=None):
    sort_key = sort_key or '_id'
    sort_value = sort_value or 1
    if limit is None:
        requests = collection.find(query).sort(sort_key, sort_value)
    else:
        requests = collection.find(query).sort(sort_key, sort_value).limit(limit)
    requests = [item for item in requests] if requests.count() else []
    return requests


def insert(collection, data):
    collection.insert(data)


def update_one(collection, query, updates, upsert=True):
    collection.update(query, {'$set': updates}, upsert=upsert)


def remove(collection, query):
    collection.remove(query)
