# coding: utf8
import time
import traceback
import threading
import multiprocessing

import logger


exctr_logger = logger.LoggerWrapper.get_logger('exctr')


class Executor(object):
    def __init__(self, executor_id=None):
        self.__id = executor_id or int(time.time() * 1000)
        self.__busy = False
        self.__proc = None
        self.__task_type = None

    @property
    def id(self):
        return self.__id

    @property
    def is_busy(self):
        if self.__proc is not None and self.__proc.is_alive():
            return True
        self.__busy = False
        return False

    @property
    def task_type(self):
        if not self.is_busy:
            return None
        return self.__task_type

    def start(self, TaskType, task_id, timeout, kwargs):
        if self.is_busy:
            exctr_logger.error('RAISE: Executor is busy')
            raise RuntimeError('Executor is busy')

        self.__proc = threading.Thread(
            target=self.__nanny,
            args=(TaskType, task_id, timeout, kwargs)
        )
        self.__busy = True
        self.__proc.start()

    def __nanny(self, TaskType, task_id, timeout, kwargs):
        try:
            task = TaskType(task_id)

            self.__fill(task, kwargs)

            job = multiprocessing.Process(target=task.run_cycle)
            job.start()
            self.__task_type = TaskType

            start = time.time()
            while job.is_alive():
                if time.time() - start > timeout:
                    job.terminate()
                time.sleep(1)
        except Exception:
            exctr_logger.tracaback(traceback.format_exc(limit=20))
        finally:
            self.__busy = False
            self.__task_type = None

    def __fill(self, task, kwargs):
        for attr, value in kwargs.items():
            if hasattr(task.Parameters, attr):
                getattr(task.Parameters, attr).value = value
            else:
                exctr_logger.warning('Attribute {} missing'.format(attr))
