# coding: utf8
import time
import random
import multiprocessing

import logger
import sdk.executor as executor


sch_logger = logger.LoggerWrapper.get_logger('schdlr')


class Scheduler(object):
    def __init__(self, tasks_queue, supported_task_types):
        self.tasks_queue = tasks_queue
        self.supported_task_types = supported_task_types
        self.executors = self.get_executors_pool()

    @staticmethod
    def get_uniq_id():
        return int(time.time()) + random.randint(1000000, 9999999)

    @staticmethod
    def get_executors_pool():
        executors = {}
        for _ in xrange(multiprocessing.cpu_count() - 1):
            executor_id = Scheduler.get_uniq_id()
            executors[executor_id] = executor.Executor(executor_id)
        return executors

    def get_free_executor(self, task_type=None):
        free_executor = None
        for executor_ in self.executors.values():
            if free_executor is None and not executor_.is_busy:
                free_executor = executor_
            if free_executor is not None and task_type is None:
                return free_executor
            if task_type is not None and executor_.task_type == task_type:
                return None
        return free_executor

    def wait_for_free_executor(self):
        executor_ = None
        while executor_ is None:
            time.sleep(1)
            executor_ = self.get_free_executor()
        return executor_

    def schedule(self):
        cycle_queue = self.tasks_queue

        while cycle_queue:
            skiped_tasks = []

            for task_record in cycle_queue:
                task_type = self.supported_task_types[task_record['type']]
                task_timeout = task_record['timeout']
                task_kwargs = task_record['kwargs']

                executor_ = self.get_free_executor(task_type)

                if executor_ is None:
                    skiped_tasks.append(task_record)
                    continue

                executor_.start(task_type, self.get_uniq_id(), task_timeout, task_kwargs)

            cycle_queue = skiped_tasks
