# coding: utf8


class Parameter(object):
    def __init__(self, label, default=None, desc='', requare=True, vfilter=None):
        self.__label = label
        self.__default = default
        self.__value = self.__default
        self.__desc = desc
        self.__requare = requare
        self.__vfilter = vfilter or (lambda x: True)

    @property
    def label(self):
        return self.__label

    @property
    def default(self):
        return self.__default

    value = property()

    @value.getter
    def value(self):
        return self.__value

    @value.setter
    def value(self, value):
        if not self.vfilter(value):
            raise ValueError('Invalid value')
        self.__value = value

    @property
    def desc(self):
        return self.__desc

    @property
    def requare(self):
        return self.__requare

    def vfilter(self, value):
        return self.__vfilter(value)


class Integer(Parameter):
    def __init__(self, label, default=None, desc='', requare=True, vfilter=None):
        super(Integer, self).__init__(label, default, desc, requare, vfilter)
        self.__vfilter = (lambda x: isinstance(x, int)) if not vfilter else \
            (lambda x: isinstance(x, int) and vfilter(x))


class Float(Parameter):
    def __init__(self, label, default=None, desc='', requare=True, vfilter=None):
        super(Float, self).__init__(label, default, desc, requare, vfilter)
        self.__vfilter = (lambda x: isinstance(x, float)) if not vfilter else \
            (lambda x: isinstance(x, float) and vfilter(x))


class String(Parameter):
    def __init__(self, label, default=None, desc='', requare=True, vfilter=None):
        super(String, self).__init__(label, default, desc, requare, vfilter)
        self.__vfilter = (lambda x: isinstance(x, str)) if not vfilter else \
            (lambda x: isinstance(x, str) and vfilter(x))


class Text(Parameter):
    def __init__(self, label, default=None, desc='', requare=True, vfilter=None):
        super(Text, self).__init__(label, default, desc, requare, vfilter)
        self.__vfilter = (lambda x: isinstance(x, str)) if not vfilter else \
            (lambda x: isinstance(x, str) and vfilter(x))


class Json(Parameter):
    def __init__(self, label, default=None, desc='', requare=True, vfilter=None):
        super(Json, self).__init__(label, default, desc, requare, vfilter)
        self.__vfilter = (lambda x: isinstance(x, str)) if not vfilter else \
            (lambda x: isinstance(x, str) and vfilter(x))


class List(Parameter):
    def __init__(self, label, default=None, desc='', requare=True, vfilter=None):
        super(List, self).__init__(label, default, desc, requare, vfilter)
        self.__vfilter = (lambda x: isinstance(x, list)) if not vfilter else \
            (lambda x: isinstance(x, list) and vfilter(x))


class Dict(Parameter):
    def __init__(self, label, default=None, desc='', requare=True, vfilter=None):
        super(Dict, self).__init__(label, default, desc, requare, vfilter)
        self.__vfilter = (lambda x: isinstance(x, dict)) if not vfilter else \
            (lambda x: isinstance(x, dict) and vfilter(x))
