# coding: utf8
import traceback

import logger


class Task(object):
    class Requirements(object):
        pass

    class Parameters(object):
        pass

    class Context(object):
        pass

    def __init__(self, id_):
        self.id = id_

        self.logger = logger.LoggerWrapper.get_logger(
            type(self).__name__,
            logger.CombinedLogger,
            loggers=[
                logger.PrintLogger(),
                logger.FileLogger(logs_dir='/logs/tasks/{}'.format(type(self).__name__))
            ]
        )

    def on_prepare(self):
        pass

    def on_execute(self):
        pass

    def on_break(self, e):
        pass

    def on_finish(self):
        pass

    def run_cycle(self):
        try:
            self.logger.info('Start on_prepare')
            self.on_prepare()
        except Exception as e:
            self.logger.error('Task `{}` throw unhandled exception `on_prepare`. {}: {}'.format(
                type(self).__name__, type(e).__name__, e
            ))

        try:
            self.logger.info('Start on_execute')
            self.on_execute()
        except Exception as e:
            try:
                self.logger.info('Start on_break ({}: {})'.format(type(e).__name__, e))
                self.logger.traceback(traceback.format_exc(limit=20))
                self.on_break(e)
            except Exception as e:
                self.logger.error('Task `{}` throw unhandled exception `on_break`. {}: {}'.format(
                    type(self).__name__, type(e).__name__, e
                ))
            return

        try:
            self.logger.info('Start on_finish')
            self.on_finish()
        except Exception as e:
            self.logger.error('Task `{}` throw unhandled exception `on_finish`. {}: {}'.format(
                type(self).__name__, type(e).__name__, e
            ))
