# coding: utf8
import task
import requests
import parameters
import sdk.tbot as tbot
import sdk.db.mongo as mongo


class TBotTask(task.Task):
    class Requirements(task.Task.Requirements):
        pass

    class Parameters(task.Task.Parameters):
        db_name = parameters.String('MongoDB', default=None)
        settings_name = parameters.String('Settings MongoDB', default=None)
        state_name = parameters.String('State MongoDB', default=None)

    class Context(task.Task.Context):
        bot = tbot.get_telegram_bot()

    def __init__(self, id_):
        super(TBotTask, self).__init__(id_)
        self.__settings = None
        self.__state = None

    @property
    def settings(self):
        if self.__settings is None:
            self.__settings = mongo.get_collection(
                mongo.HEARTBEAT_DEFAULT, self.Parameters.db_name.value, self.Parameters.settings_name.value
            )
        return mongo.find_one(self.__settings, {'id': 0, 'type': self.__class__.__name__})

    @property
    def state(self):
        if self.__state is None:
            self.__state = mongo.get_collection(
                mongo.HEARTBEAT_DEFAULT, self.Parameters.db_name.value, self.Parameters.state_name.value
            )
        return mongo.find_one(self.__state, {'id': 0, 'type': self.__class__.__name__})

    def upadte_settings(self, data):
        mongo.update_one(self.__settings, {'id': 0, 'type': self.__class__.__name__}, data)

    def upadte_state(self, data):
        mongo.update_one(self.__state, {'id': 0, 'type': self.__class__.__name__}, data)

    def send_message(self, chat_id, message):
        if chat_id not in mongo.find_one(self.__settings, {'id': 0, 'type': 'SECURITY'})['whitelist']:
            return
        self.Context.bot.send_message(chat_id, message)

    def send_notifications_to_followers(self, message):
        skiped_followers = 0
        for chat_id in self.settings['followers']:
            try:
                self.send_message(chat_id, message)
            except Exception:
                self.logger.warning('Can not send message to {} - SKIP'.format(chat_id))
                skiped_followers += 1

        if skiped_followers >= len(self.settings['followers']):
            self.logger.warning('Can not send message to ALL followers - RAISE')
            raise Exception('Can not send message to ALL followers')

    def get_gencfg_monitoring_state(self):
        for url in ('http://man1-4435-man-gencfg-monitoring-14646.gencfg-c.yandex.net:14646',
                    'http://sas2-6375-sas-gencfg-monitoring-18274.gencfg-c.yandex.net:18274',
                    'http://vla1-4676-vla-gencfg-monitoring-18274.gencfg-c.yandex.net:18274',
                    'http://man1-4435.search.yandex.net:14646',
                    'http://sas2-6375.search.yandex.net:18274',
                    'http://vla1-4676.search.yandex.net:18274'):
            try:
                return requests.get(url).json()
            except Exception as e:
                self.logger.error('get_gencfg_monitoring_state ({}: {})'.format(type(e), e))
        raise ValueError('Cannot load data from monitoring.')
