# coding: utf8
import datetime

import sdk.tasks as tasks


class GencfgRequestsDelayNotificator(tasks.TBotTask):
    class Parameters(tasks.TBotTask.Parameters):
        pass

    class Context(tasks.TBotTask.Context):
        monitoring = {}
        messages = []
        error = False

    def send_bad_notify(self, text):
        self.send_notifications_to_followers(
            '{}\nhttps://yasm.yandex-team.ru/panel/GencfgMonitoring/'.format(
                text
            )
        )

    def send_good_notify(self, text):
        self.send_notifications_to_followers(text)

    def on_prepare(self):
        self.Context.monitoring = self.get_gencfg_monitoring_state()

    def to_date(self, date_string):
        return datetime.datetime.strptime(date_string, '%Y-%m-%d %H:%M:%S')

    @property
    def gm_requests_delay(self):
        return int(self.Context.monitoring['delays']['requests']['value'])

    @property
    def gm_requests_updated(self):
        return self.to_date(self.Context.monitoring['delays']['requests']['updated'])

    @property
    def db_requests_delay(self):
        return int(self.state['delays']['requests']['value'])

    @property
    def db_requests_status(self):
        return int(self.state['delays']['requests']['status'])

    @property
    def db_requests_updated(self):
        return self.state['delays']['requests']['updated']

    @property
    def db_max_requests_delay(self):
        return int(self.settings['delays']['requests'])

    @property
    def is_requests_delay_actuality(self):
        return self.db_requests_updated >= self.gm_requests_updated

    @property
    def is_db_has_error(self):
        return not self.db_requests_status

    def db_update_delay(self, value):
        self.upadte_state({
            'delays.requests.value': value
        })

    def db_update_status(self, status):
        self.upadte_state({
            'delays.requests.status': status,
            'delays.requests.updated': datetime.datetime.utcnow()
        })

    def on_execute(self):
        if self.is_requests_delay_actuality:
            self.logger.info('INFO IN DB IS ACTUALITY - SKIP PROCESSING')
            return

        self.Context.error = self.is_db_has_error
        self.logger.info('DB: Error - {}'.format(self.Context.error))
        self.logger.info('DB: Max Delay - {}'.format(self.db_max_requests_delay))

        new_error = False
        if self.gm_requests_delay > self.db_max_requests_delay:
            new_error = True
        self.db_update_delay(self.gm_requests_delay)

        self.logger.info('GM: Error - {}'.format(new_error))
        self.logger.info('GM: Delay - {}'.format(self.gm_requests_delay))

        if self.Context.error != new_error:
            if new_error:
                self.send_bad_notify('REQUESTS: delay more than {}m'.format(self.db_max_requests_delay / 60))
                self.logger.info('NOTIFY: REQUESTS: delay more than {}m'.format(self.db_max_requests_delay / 60))
            else:
                self.send_good_notify('Requests work normally.')
                self.logger.info('NOTIFY: Requests work normally.')

            self.db_update_status(not new_error)
            self.logger.info('UPDATE: Status -> {} updated'.format(not new_error))
