MONGODB_URI = ['mongodb://127.0.0.1/']

MONGODB_DB_NAME = 'genisys'

STATSD_HOST = '127.0.0.1'

STATSD_PORT = 8125

EMAIL_LINKS_BASE = 'https://genisys.yandex-team.ru'

EMAIL_ADDRESS_FROM_ALIAS = 'genisys'

EMAIL_SUBJECT_PREFIX = '[genisys] '

EMAIL_ADDRESS_FROM_ADDRESS = 'noreply@genisys.yandex-team.ru'

# must be in sync with genisys.web.config.EMAIL_MAX_RECIPIENTS
EMAIL_MAX_RECIPIENTS = 50

SANDBOX_URI = 'https://sandbox.yandex-team.ru/api/v1.0'

#SMTP_SERVER = 'yabacks.yandex.ru'

#SMTP_PORT = 25

STAFF_URI = 'https://staff-api.yandex-team.ru/v3'

# in seconds
STAFF_TIMEOUT = 60

##STAFF_HEADERS = {'Authorization': 'OAuth {access_token}'}

PROCESS_ONLY_VTYPES = None

EAGER = False

FORCED_UPDATE_FROM_MTIME = None

# postpone time = min(MAX_POSTPONE_TIME, MIN_POSTPONE_TIME + (POSTPONE_BACKOFF_BASE ** postpone_count) - 1)
POSTPONE_BACKOFF_BASE = 1.3
MAX_POSTPONE_TIME = 20 * 60
MIN_POSTPONE_TIME = 5

TOILER_SLEEP_ON_NOTHING_TO_DO = 5


# specific vtype-processors config

# selector
SELECTOR_SKY_LIST = ('sky', 'list')
SELECTOR_SKY_LIST_TIMEOUT = 10 * 60
SELECTOR_RESULT_TTL = 300

# section
SECTION_RESULT_TTL = 60 * 5
SECTION_MAX_SELECTOR_FAIL_DURATION = SELECTOR_SKY_LIST_TIMEOUT * 3
SECTION_MAX_SELECTOR_POSTPONES = 6

# sandbox_releases
SANDBOX_RELEASES_LIMIT = 100
SANDBOX_RELEASES_RESULT_TTL = 60 * 5
SANDBOX_RELEASES_SANDBOX_API_TIMEOUT = 60

# sandbox_resource
SANDBOX_RESOURCE_RESULT_TTL = 60 * 5
SANDBOX_RESOURCE_SANDBOX_API_TIMEOUT = SANDBOX_RELEASES_SANDBOX_API_TIMEOUT


import os
if 'GENISYS_TOILER_CONFIG' in os.environ:
    filename = os.environ['GENISYS_TOILER_CONFIG']
    try:
        with open(filename) as config_file:
            exec(compile(config_file.read(), filename, 'exec'), globals())
    except BaseException as ex:
        import sys
        import os

        sys.stderr.write('Error: unable to load config from %s: %s\n' % (filename, ex))
        sys.stderr.flush()
        os._exit(1)

    del os.environ['GENISYS_TOILER_CONFIG']
