import requests

from genisys.toiler import config


def sandbox_releases_vtype_processor(database, record, forced):
    resource_type = record['source']['resource_type']
    url = config.SANDBOX_URI + "/resource"
    params = {'type': resource_type,
              'limit': config.SANDBOX_RELEASES_LIMIT,
              'state': 'READY',
              'attrs': '{"released": "stable"}',
              'order': '-time.created'}
    resp = requests.get(url, params,
                        timeout=config.SANDBOX_RELEASES_SANDBOX_API_TIMEOUT)
    yield "got request from sandbox, status_code={}".format(resp.status_code)
    resp.raise_for_status()
    result = []
    for release in resp.json()['items']:
        result.append({'description': release['description'],
                       'resource_id': release['id']})
    return result, record['meta']

sandbox_releases_vtype_processor.RESULT_TTL = config.SANDBOX_RELEASES_RESULT_TTL
