import requests

from genisys.toiler import config


def sandbox_resource_vtype_processor(database, record, forced):
    resource_id = record['source']['resource_id']
    yield "trying to get info on resource #{}".format(resource_id)
    url = config.SANDBOX_URI + "/resource/{}".format(resource_id)
    resp = requests.get(url,
                        timeout=config.SANDBOX_RESOURCE_SANDBOX_API_TIMEOUT)
    yield "got request from sandbox, status_code={}".format(resp.status_code)
    resp.raise_for_status()
    result = resp.json()
    # apparently these lists come in no particular order. we have to impose
    # some order just to make sure that equal values compare equal
    result['http']['links'].sort()
    result['rsync']['links'].sort()
    result['sources'].sort()
    return result, record['meta']

sandbox_resource_vtype_processor.RESULT_TTL = config.SANDBOX_RESOURCE_RESULT_TTL
