import subprocess

from genisys.toiler import base, config


def selector_vtype_processor(database, record, forced):
    args = config.SELECTOR_SKY_LIST + (record['source'].strip(), )
    yield "executing {}".format(args)
    skylist = subprocess.Popen(args, stdout=subprocess.PIPE,
                               stderr=subprocess.PIPE)
    started = base._get_ts()
    time_spent = 0
    while time_spent < config.SELECTOR_SKY_LIST_TIMEOUT:
        try:
            stdout, stderr = skylist.communicate(timeout=30)
        except subprocess.TimeoutExpired:
            time_spent = base._get_ts() - started
            yield "spent {:.3f} seconds waiting for sky list " \
                  "result so far".format(time_spent)
            continue
        else:
            break
    else:
        skylist.kill()
        raise base.ProcError("caught timeout while reading from sky list")

    time_spent = base._get_ts() - started
    yield "sky list overall time spent: {:.3f} seconds".format(time_spent)

    for line in stderr.decode('latin1').splitlines():
        yield "sky list stderr: %s" % (line, )

    yield "sky list return code = %d" % (skylist.returncode, )
    if skylist.returncode != 0:
        raise base.ProcError()

    return sorted(stdout.decode('latin1').splitlines()), record['meta']

selector_vtype_processor.RESULT_TTL = config.SELECTOR_RESULT_TTL
