import statsd


class _NopTimer:
    def __enter__(self):
        pass
    def __exit__(self, *args, **kwargs):
        pass


class ToilerStats:
    _nop_timer = _NopTimer()

    def __init__(self, host, port):
        if not host or not port:
            self._statsd = None
            return
        self._statsd = statsd.StatsClient(host, port)
        for fn in ('incr', 'timing', 'timer'):
            setattr(self, fn, getattr(self._statsd, fn))

    def incr(self, *args, **kwargs):
        pass

    timing = incr

    def timer(self, *args, **kwargs):
        return self._nop_timer
