# ================================
# genisys storage specific options
# ================================

# http://docs.mongodb.org/manual/reference/connection-string/
##MONGODB_URI

MONGODB_DB_NAME = 'genisys'

# in milliseconds
MONGODB_SERVER_SELECTION_TIMEOUT = 3000


# ============================
# genisys web specific options
# ============================

BABEL_DEFAULT_TIMEZONE = 'Europe/Moscow'

BLACKBOX_URI = 'https://blackbox.yandex-team.ru/blackbox'

# http://urllib3.readthedocs.org/en/latest/helpers.html#urllib3.util.retry.Retry
BLACKBOX_RETRY_PARAMS = dict(
    total=10,
    status_forcelist=frozenset((400, 404, 500, 502, 503)),
    backoff_factor=0.01
)

# in seconds
BLACKBOX_TIMEOUT = 3

SANDBOX_URI = 'https://sandbox.yandex-team.ru/api/v1.0'

PASSPORT_URI = 'https://passport.yandex-team.ru/passport'

RENEW_AUTH_COOKIE_URI = 'https://pass.yandex-team.ru/resign'

STAFF_URI = 'https://staff-api.yandex-team.ru/v3'

# in seconds
STAFF_TIMEOUT = 6

##STAFF_HEADERS = {'Authorization': 'OAuth {access_token}'}

# set to True to disable checking lists of usernames in form fields against
# staff api and assume all usernames are valid
##BYPASS_STAFF_USERNAMES_CHECK = False

# a tuple of (hostname/ip, port)
##WSGI_LISTEN_ADDRESS

# genisys api address
##GENISYS_API_URI = 'http://127.0.0.1:5000'

# set to True to disable current user auth check against blackbox/passport apis
##BYPASS_AUTH = False

# if BYPASS_AUTH is True, this will be set as current logged in user username
# for everyone
##BYPASS_AUTH_AS = 'hardcodeuser'

# if BYPASS_AUTH is True. this will supplement logged in user group names
##BYPASS_AUTH_AS_GROUPS = []

# change automatically detected url scheme in generated absolute
# urls to specified one
#FORCE_URL_SCHEME = 'https'

# number of records on the section history page
HISTORY_PAGE_SIZE = 30

# hostname of statsd collector
STATSD_HOST = '127.0.0.1'

# udp port of statsd collector
STATSD_PORT = 8125

# this affects collection of stats on unhandled exceptions when enabled
PRESERVE_CONTEXT_ON_EXCEPTION = False


# ============================
# genisys api specific options
# ============================

API_CACHE_VALIDITY_RANGE = (10, 20)

# must be in sync with genisys.toiler.config['EMAIL_MAX_RECIPIENTS']
EMAIL_MAX_RECIPIENTS = 50


# =====================================================================
# builtin flask configuration options go below, see
# http://flask.pocoo.org/docs/0.10/config/#builtin-configuration-values
# =====================================================================

# enable/disable debug mode
##DEBUG

# enable/disable testing mode
##TESTING

# explicitly enable or disable the propagation of exceptions. If not set or
# explicitly set to None this is implicitly true if either TESTING or DEBUG
# is true.
##PROPAGATE_EXCEPTIONS

# By default if the application is in debug mode the request context is not
# popped on exceptions to enable debuggers to introspect the data. This can
# be disabled by this key. You can also use this setting to force-enable
# it  for non debug execution which might be useful to debug production
# applications (but also very risky).
##PRESERVE_CONTEXT_ON_EXCEPTION

# the secret key
##SECRET_KEY

# the name of the session cookie
##SESSION_COOKIE_NAME

# the domain for the session cookie. If this is not set, the cookie
# will be valid for all subdomains of SERVER_NAME.
##SESSION_COOKIE_DOMAIN

# the path for the session cookie. If this is not set the cookie
# will be valid for all of APPLICATION_ROOT or if that is not set for '/'.
##SESSION_COOKIE_PATH

# controls if the cookie should be set with the httponly flag.
# Defaults to True.
##SESSION_COOKIE_HTTPONLY

# controls if the cookie should be set with the secure flag.
# Defaults to False.
##SESSION_COOKIE_SECURE

# the lifetime of a permanent session as datetime.timedelta object.
# Starting with Flask 0.8 this can also be an integer representing seconds.
##PERMANENT_SESSION_LIFETIME

# enable/disable x-sendfile
##USE_X_SENDFILE

# the name of the logger
##LOGGER_NAME

# the name and port number of the server. Required for subdomain support
# (e.g.: 'myapp.dev:5000') Note that localhost does not support subdomains
# so setting this to "localhost" does not help. Setting a SERVER_NAME also
# by default enables URL generation without a request context but with
# an application context.
##SERVER_NAME

# If the application does not occupy a whole domain or subdomain this
# can be set to the path where the application is configured to live.
# This is for session cookie as path value. If domains are used, this
# should be None.
##APPLICATION_ROOT

# If set to a value in bytes, Flask will reject incoming requests with
# a content length greater than this by returning a 413 status code.
##MAX_CONTENT_LENGTH

# Default cache control max age to use with send_static_file() (the default
# static file handler) and send_file(), in seconds. Override this value
# on a per-file basis using the get_send_file_max_age() hook on Flask
# or Blueprint, respectively. Defaults to 43200 (12 hours).
##SEND_FILE_MAX_AGE_DEFAULT

# If this is set to True Flask will not execute the error handlers of HTTP
# exceptions but instead treat the exception like any other and bubble
# it through the exception stack. This is helpful for hairy debugging
# situations where you have to find out where an HTTP exception
# is coming from.
##TRAP_HTTP_EXCEPTIONS

# Werkzeug's internal data structures that deal with request specific data
# will raise special key errors that are also bad request exceptions.
# Likewise many operations can implicitly fail with a BadRequest exception
# for consistency. Since it's nice for debugging to know why exactly
# it failed this flag can be used to debug those situations. If this
# config is set to True you will get a regular traceback instead.
##TRAP_BAD_REQUEST_ERRORS

# The URL scheme that should be used for URL generation if no URL scheme
# is available. This defaults to http.
##PREFERRED_URL_SCHEME

# By default Flask serialize object to ascii-encoded JSON. If this is set
# to False Flask will not encode to ASCII and output strings as-is and
# return unicode strings. jsonfiy will automatically encode it in utf-8
# then for transport for instance.
##JSON_AS_ASCII

# By default Flask will serialize JSON objects in a way that the keys
# are ordered. This is done in order to ensure that independent of the
# hash seed of the dictionary the return value will be consistent to not
# trash external HTTP caches. You can override the default behavior
# by changing this variable. This is not recommended but might give you
# a performance improvement on the cost of cachability.
##JSON_SORT_KEYS

# If this is set to True (the default) jsonify responses will be pretty
# printed if they are not requested by an XMLHttpRequest object (controlled
# by the X-Requested-With header)
##JSONIFY_PRETTYPRINT_REGULAR
