import werkzeug.exceptions


class GenisysError(Exception):
    pass


class ModelError(GenisysError):
    pass


class NotUnique(ModelError, werkzeug.exceptions.Conflict):
    pass


class NotFound(ModelError, werkzeug.exceptions.NotFound):
    pass


class Unauthorized(ModelError, werkzeug.exceptions.Unauthorized):
    pass


class Outdated(ModelError, werkzeug.exceptions.Conflict):
    pass
