from werkzeug.routing import BaseConverter

from genisys.web import views, model


class VHashConverter(BaseConverter):
    regex = model.VOLATILE_KEY_HASH_REGEXP

    def to_url(self, value):
        value = model.volatile_key_hash(value)
        return super(VHashConverter, self).to_url(value)


def setup_routes(app, csrf):
    app.url_map.converters['vhash'] = VHashConverter

    app.add_url_rule('/', 'index', redirect_to='/sections/')
    app.add_url_rule('/dashboard', view_func=views.dashboard)
    app.add_url_rule('/mark-unmark-section/<path>',
                     view_func=views.mark_unmark_section, methods=['POST'])
    app.add_url_rule('/sections', redirect_to='/sections/',
                     endpoint='sections-noslash')
    app.add_url_rule('/sections/<string(minlength=0):path>',
                     view_func=views.section, methods=['GET', 'POST'])
    app.add_url_rule('/aliases/<string(minlength=0):path>',
                     view_func=views.aliases, methods=['GET', 'POST'])
    app.add_url_rule('/revert-rules/<string(minlength=0):path>',
                     view_func=views.revert_rules, methods=['POST'])
    app.add_url_rule('/section-status', redirect_to='/section-status/',
                     endpoint='section-status-noslash')
    app.add_url_rule('/rules/<path:rulename>', defaults={'path': ''},
                     view_func=views.rule, methods=['GET', 'POST'])
    app.add_url_rule('/rules/<path>/<path:rulename>',
                     view_func=views.rule, methods=['GET', 'POST'])
    app.add_url_rule('/history', redirect_to='/history/',
                     endpoint='history-noslash')
    app.add_url_rule('/history/<string(minlength=0):path>',
                     view_func=views.history, methods=['GET'])
    app.add_url_rule('/delete/<path>',
                     view_func=views.delete_empty_section, methods=['POST'])
    app.add_url_rule('/matching-rules/<string(minlength=0):path>',
                     view_func=views.get_matching_rules, methods=['POST'])
    csrf.exempt(views.get_matching_rules)

    app.add_url_rule('/volatile/raw-status/<vtype>/<vhash:key>',
                     methods=['GET'], view_func=views.raw_volatile_status)
    app.add_url_rule('/volatile/status/<vtype>/<vhash:key>',
                     methods=['GET'], view_func=views.volatile_status)

    app.add_url_rule('/volatile/force-update/<vtype>/<vhash:key>',
                     methods=['POST'], view_func=views.force_volatile_update)
    csrf.exempt(views.force_volatile_update)
    app.add_url_rule('/volatile/updated/<vtype>/<vhash:key>/<int:timestamp>',
                     methods=['GET'], view_func=views.get_updated_volatile)

    app.add_url_rule('/show-config',
                     view_func=views.show_config, methods=['GET'])

    app.add_url_rule('/ping', view_func=views.ping, methods=['GET'])

    app.add_url_rule('/group/<groupname>', view_func=views.group,
                     methods=['GET'])
