package main

import (
	"flag"
	"fmt"
	"time"

	"a.yandex-team.ru/infra/gopcm/pkg/membw"
	"a.yandex-team.ru/infra/gopcm/pkg/pcm"
)

func main() {

	var numIter = flag.Int("i", 10, "number of iterations")
	var numDelay = flag.Int("d", 1, "delay between iterations")
	flag.Parse()

	delay := *numDelay
	if *numDelay < 1 {
		delay = 1
	}

	pcm, err := pcm.Init()
	if err != nil {
		panic(err)
	}
	m, err := membw.Init(pcm)
	if err != nil {
		panic(err)
	}
	defer pcm.Close()

	for iter := 0; iter < *numIter; iter++ {
		time.Sleep(time.Duration(delay) * time.Second)
		err := m.Update(true)
		if err != nil {
			fmt.Printf("Could not update memory BW metrics %s\n", err)
			continue
		}
		m.BW()
	}
}
