package endian

import (
	"encoding/binary"
	"unsafe"
)

var native binary.ByteOrder

func Endian() binary.ByteOrder {
	if native == nil {
		var x uint32 = 0x01020304
		if *(*byte)(unsafe.Pointer(&x)) == 0x01 {
			native = binary.BigEndian
		} else {
			native = binary.LittleEndian
		}
	}
	return native
}
