package ipc

import "math"

type Values []float64

func (ipcval Values) Average() float64 {
	summ := float64(0)
	for _, val := range ipcval {
		summ += val
	}
	lenVal := len(ipcval)
	if lenVal != 0 {
		return summ / float64(lenVal)
	}
	return 0
}

func (ipcval Values) MinMax() (float64, float64) {
	min := theorMax
	max := 0.0

	for _, val := range ipcval {
		if val < min {
			min = val
		}
		if val > max {
			max = val
		}
	}
	return min, max
}

func (ipcval Values) Percentile(p uint16) float64 {
	if p == 0 {
		p = 1
	}
	if p > 100 {
		p = 100
	}
	lenVal := len(ipcval)
	if lenVal == 0 {
		return 0
	}

	idx := int(math.Round(float64(p) * float64(lenVal) / 100))
	if idx >= lenVal {
		idx = lenVal - 1
	}
	return ipcval[idx]
}

func (ipcval Values) isAllZeros() bool {
	for _, val := range ipcval {
		if val > 0 {
			return false
		}
	}
	return true
}
