package ipc

import (
	"testing"
)

func TestAverage(t *testing.T) {
	ipcv := Values{1, 1, 1, 1}

	expected := float64(1)
	got := ipcv.Average()
	if got != expected {
		t.Errorf("expextedAverage != Average(); want %f, got %f", expected, got)
	}

	ipcv = Values{}
	expected = float64(0)
	got = ipcv.Average()

	if got != expected {
		t.Errorf("expextedAverage != Average(); want %f, got %f", expected, got)
	}
}

func TestMinMax(t *testing.T) {
	ipcv := Values{0, 1, 3, 1}
	expMin := 0.0
	expMax := 3.0

	gotMin, gotMax := ipcv.MinMax()
	if gotMin != expMin {
		t.Errorf("expected min != min from MinMax(); want %f, got %f", expMin, gotMin)
	}
	if gotMax != expMax {
		t.Errorf("expected min != min from MinMax(); want %f, got %f", expMin, gotMin)
	}

	ipcv = []float64{1, 1, 1, 1}
	expMin = 1.0
	expMax = 1.0

	gotMin, gotMax = ipcv.MinMax()
	if gotMin != expMin {
		t.Errorf("expected min != min from MinMax(); want %f, got %f", expMin, gotMin)
	}
	if gotMax != expMax {
		t.Errorf("expected min != min from MinMax(); want %f, got %f", expMin, gotMin)
	}
}

func TestPercentile(t *testing.T) {
	ipc := Values{0, 1, 2, 3, 3, 4, 5, 5, 6, 6, 8}

	expected := 8.0
	got := ipc.Percentile(100)
	if got != expected {
		t.Errorf("expectet Perc != Percentile(); want %f, got %f", expected, got)
	}

	ipc = Values{}
	expected = 0
	got = ipc.Percentile(50)
	if got != expected {
		t.Errorf("expectet Perc != Percentile(); want %f, got %f", expected, got)
	}
}
