package mcfg

import (
	"bytes"

	"a.yandex-team.ru/infra/gopcm/internal/endian"
)

const (
	MCFGHeaderSize = 44
)

type MCFGHeader struct {
	Signature      string
	Length         uint32
	Revision       uint8
	Checksum       uint8
	OEMID          string
	OEMTableID     string
	OEMRevision    uint32
	CreatorID      uint32
	CreatorRevison uint32
	Reserved       []byte
}

func (mh *MCFGHeader) Deserialize(b MCFGHeaderContent) error {
	buf := bytes.NewBuffer(b)
	native := endian.Endian()

	mh.Signature = string(buf.Next(4))
	mh.Length = native.Uint32(buf.Next(4))

	next, err := buf.ReadByte()
	if err != nil {
		return nil
	}
	mh.Revision = next

	next, err = buf.ReadByte()
	if err != nil {
		return nil
	}
	mh.Checksum = next

	mh.OEMID = string(buf.Next(6))
	mh.OEMTableID = string(buf.Next(8))
	mh.OEMRevision = native.Uint32(buf.Next(4))

	mh.CreatorID = native.Uint32(buf.Next(4))
	mh.CreatorRevison = native.Uint32(buf.Next(4))

	mh.Reserved = buf.Next(8)
	return nil
}
