package mcfg

var (
	MCFGPaths = []string{
		"/sys/firmware/acpi/tables/MCFG",
		"/sys/firmware/acpi/tables/MCFG1",
	}
)

func Parse() (*MCFGHeader, []*MCFGRecord, error) {
	content, err := readContent()
	if err != nil {
		return nil, nil, err
	}

	if err := content.check(); err != nil {
		return nil, nil, err
	}

	hc, err := content.headerContent()
	if err != nil {
		return nil, nil, err
	}

	header := &MCFGHeader{}
	err = header.Deserialize(hc)
	if err != nil {
		return nil, nil, err
	}

	rc, err := content.recordsContent()
	if err != nil {
		return nil, nil, err
	}

	records := []*MCFGRecord{}
	for i := 0; i < rc.numberOfRecords(); i++ {
		rec := &MCFGRecord{}
		err := rec.Deserialize(rc)
		if err != nil {
			return nil, nil, err
		}
		records = append(records, rec)
	}
	return header, records, nil
}
