package mcfg

import (
	"bytes"

	"a.yandex-team.ru/infra/gopcm/internal/endian"
)

const (
	MCFGRecordSize = 16
)

type MCFGRecord struct {
	BaseAddress        uint64
	SegmentGroupNumber uint16
	StartBusNumber     uint8
	EndBusNumber       uint8
	Reserved           []byte
}

func (mr *MCFGRecord) Deserialize(b MCFGRecordsContent) error {
	native := endian.Endian()
	buf := bytes.NewBuffer(b)
	mr.BaseAddress = native.Uint64(buf.Next(8))
	mr.SegmentGroupNumber = native.Uint16(buf.Next(2))

	next, err := buf.ReadByte()
	if err != nil {
		return err
	}
	mr.StartBusNumber = next

	next, err = buf.ReadByte()
	if err != nil {
		return err
	}
	mr.EndBusNumber = next
	mr.Reserved = buf.Next(4)
	return nil
}
