package msr

import (
	"bytes"
	"fmt"
	"os"

	"a.yandex-team.ru/infra/gopcm/internal/endian"
)

type MsrHandle struct {
	id int
	fd *os.File
}

var baseMsrPath = "/dev/cpu/%d/msr"

func Init(cpuID int) (*MsrHandle, error) {
	msrPath := fmt.Sprintf(baseMsrPath, cpuID)
	handle, err := os.OpenFile(msrPath, os.O_RDWR, 0600)
	if err != nil {
		return nil, err
	}
	r := &MsrHandle{
		id: cpuID,
		fd: handle,
	}
	return r, nil
}

func (m *MsrHandle) Close() error {
	err := m.fd.Close()
	if err != nil {
		return err
	}
	return nil
}

func (m *MsrHandle) Read(msrNumber uint64) (uint64, error) {
	native := endian.Endian()
	b := make([]byte, 8)
	buf := bytes.NewBuffer(b)
	_, err := m.fd.ReadAt(b, int64(msrNumber))
	if err != nil {
		return 0, err
	}
	return native.Uint64(buf.Next(8)), nil

}

func (m *MsrHandle) Write(msrNumber uint64, value uint64) error {
	native := endian.Endian()
	b := make([]byte, 8)
	native.PutUint64(b, uint64(value))
	_, err := m.fd.WriteAt(b, int64(msrNumber))
	if err != nil {
		return err
	}
	return nil
}
