package pcm

const (
	IA32CrPerfGlobalCtrl = 0x38F
	IA32CrFixedCtrCtrl   = 0x38D
)

type fixedEventControlRegister struct {
	// in fact, this values should be bits
	os0        uint64
	usr0       uint64
	anyThread0 uint64
	enablePmi0 uint64

	os1        uint64
	usr1       uint64
	anyThread1 uint64
	enablePmi1 uint64

	os2        uint64
	usr2       uint64
	anyThread2 uint64
	enablePmi2 uint64
}

func (f *fixedEventControlRegister) Uint64() uint64 {
	// TODO: Issues with endians?
	return (f.os0 << 0) + (f.usr0 << 1) + (f.anyThread0 << 2) + (f.enablePmi0 << 3) +
		(f.os1 << 4) + (f.usr1 << 5) + (f.anyThread1 << 6) + (f.enablePmi1 << 7) +
		(f.os2 << 8) + (f.usr2 << 9) + (f.anyThread2 << 10) + (f.enablePmi2 << 11)
}

func (p *Pcm) ProgramDefCoreCounters(coreID int) error {

	ctrlReg := fixedEventControlRegister{
		os0:        1,
		usr0:       1,
		anyThread0: 0,
		enablePmi0: 0,

		os1:        1,
		usr1:       1,
		anyThread1: 0,
		enablePmi1: 0,

		os2:        1,
		usr2:       1,
		anyThread2: 0,
		enablePmi2: 0,
	}

	// Disable counting while programming
	err := p.msrs[coreID].Write(IA32CrPerfGlobalCtrl, 0)
	if err != nil {
		return err
	}
	// get current ctrl counters
	// curVal, err = p.msrs[coreID].Read(IA32CrFixedCtrCtrl)
	// if err != nil {
	// 	return err
	// }

	// Set default counters
	err = p.msrs[coreID].Write(IA32CrFixedCtrCtrl, ctrlReg.Uint64())
	if err != nil {
		return err
	}

	// Start counting
	startVal := (uint64(1) << 0) + (uint64(1) << 1) + (uint64(1) << 2) + (uint64(1) << 3) + (uint64(1) << 32) + (uint64(1) << 33) + (uint64(1) << 34)
	return p.msrs[coreID].Write(IA32CrPerfGlobalCtrl, startVal)
}
