package pcm

import (
	"a.yandex-team.ru/infra/gopcm/pkg/pci"
)

type hwRegister32 struct {
	Handle *pci.PciHandle
	Offset int
}

type hwRegister64 struct {
	Handle *pci.PciHandle
	Offset int
}

func (hwr *hwRegister32) Read() (uint32, error) {
	val, err := hwr.Handle.Read32(uint32(hwr.Offset))
	if err != nil {
		return 0, err
	}
	return val, nil

}

func (hwr *hwRegister32) Write(value uint32) error {
	err := hwr.Handle.Write32(value, uint32(hwr.Offset))
	if err != nil {
		return err
	}
	return nil
}

func (hwr *hwRegister64) Read() (uint64, error) {
	val, err := hwr.Handle.Read64(uint32(hwr.Offset))
	if err != nil {
		return 0, err
	}
	return val, nil

}

func (hwr *hwRegister64) Write(value uint64) error {
	err := hwr.Handle.Write64(value, uint32(hwr.Offset))
	if err != nil {
		return err
	}
	return nil
}
