package pcm

const (
	MaxNumSockets = 4 // 256 in open pcm, but why?
)

type MemData struct {
	ImcReadSkt      [MaxNumSockets]float64
	ImcWriteSkt     [MaxNumSockets]float64
	ImcReadSktChan  [MaxNumSockets][MaxChannels]float64
	ImcWriteSktChan [MaxNumSockets][MaxChannels]float64
}

func (m *MemData) summ(memDataCounters [MaxNumSockets]float64) float64 {
	var summ float64
	for _, val := range memDataCounters {
		summ += val
	}
	return summ
}

func (m *MemData) Reads() float64 {
	return m.summ(m.ImcReadSkt)
}

func (m *MemData) Writes() float64 {
	return m.summ(m.ImcWriteSkt)
}

func (m *MemData) Overall() float64 {
	return m.Reads() + m.Writes()
}
