package pcm

const (
	JktivtMc0Ch0RegisterDevAddr  = 16
	JktivtMc0Ch1RegisterDevAddr  = 16
	JktivtMc0Ch2RegisterDevAddr  = 16
	JktivtMc0Ch3RegisterDevAddr  = 16
	JktivtMc0Ch0RegisterFuncAddr = 4
	JktivtMc0Ch1RegisterFuncAddr = 5
	JktivtMc0Ch2RegisterFuncAddr = 0
	JktivtMc0Ch3RegisterFuncAddr = 1
	JktivtMc1Ch0RegisterDevAddr  = 30
	JktivtMc1Ch1RegisterDevAddr  = 30
	JktivtMc1Ch2RegisterDevAddr  = 30
	JktivtMc1Ch3RegisterDevAddr  = 30
	JktivtMc1Ch0RegisterFuncAddr = 4
	JktivtMc1Ch1RegisterFuncAddr = 5
	JktivtMc1Ch2RegisterFuncAddr = 0
	JktivtMc1Ch3RegisterFuncAddr = 1
	HsxMc0Ch0RegisterDevAddr     = 20
	HsxMc0Ch1RegisterDevAddr     = 20
	HsxMc0Ch2RegisterDevAddr     = 21
	HsxMc0Ch3RegisterDevAddr     = 21
	HsxMc0Ch0RegisterFuncAddr    = 0
	HsxMc0Ch1RegisterFuncAddr    = 1
	HsxMc0Ch2RegisterFuncAddr    = 0
	HsxMc0Ch3RegisterFuncAddr    = 1
	HsxMc1Ch0RegisterDevAddr     = 23
	HsxMc1Ch1RegisterDevAddr     = 23
	HsxMc1Ch2RegisterDevAddr     = 24
	HsxMc1Ch3RegisterDevAddr     = 24
	HsxMc1Ch0RegisterFuncAddr    = 0
	HsxMc1Ch1RegisterFuncAddr    = 1
	HsxMc1Ch2RegisterFuncAddr    = 0
	HsxMc1Ch3RegisterFuncAddr    = 1
	KnlMc0Ch0RegisterDevAddr     = 8
	KnlMc0Ch1RegisterDevAddr     = 8
	KnlMc0Ch2RegisterDevAddr     = 8
	KnlMc0Ch0RegisterFuncAddr    = 2
	KnlMc0Ch1RegisterFuncAddr    = 3
	KnlMc0Ch2RegisterFuncAddr    = 4
	SkxMc0Ch0RegisterDevAddr     = 10
	SkxMc0Ch1RegisterDevAddr     = 10
	SkxMc0Ch2RegisterDevAddr     = 11
	SkxMc0Ch3RegisterDevAddr     = -1 //Does not exist
	SkxMc0Ch0RegisterFuncAddr    = 2
	SkxMc0Ch1RegisterFuncAddr    = 6
	SkxMc0Ch2RegisterFuncAddr    = 2
	SkxMc0Ch3RegisterFuncAddr    = -1 //Does not exist
	SkxMc1Ch0RegisterDevAddr     = 12
	SkxMc1Ch1RegisterDevAddr     = 12
	SkxMc1Ch2RegisterDevAddr     = 13
	SkxMc1Ch3RegisterDevAddr     = -1 //Does not exist
	SkxMc1Ch0RegisterFuncAddr    = 2
	SkxMc1Ch1RegisterFuncAddr    = 6
	SkxMc1Ch2RegisterFuncAddr    = 2
	SkxMc1Ch3RegisterFuncAddr    = -1 //Does not exist
	KnlMc1Ch0RegisterDevAddr     = 9
	KnlMc1Ch1RegisterDevAddr     = 9
	KnlMc1Ch2RegisterDevAddr     = 9
	KnlMc1Ch0RegisterFuncAddr    = 2
	KnlMc1Ch1RegisterFuncAddr    = 3
	KnlMc1Ch2RegisterFuncAddr    = 4
	XpfMcChPciPmonBoxCtlAddr     = 0x0F4
	KnxMcChPciPmonBoxCtlAddr     = 0xB30
	XpfMcChPciPmonFixedCtlAddr   = 0x0F0
	XpfMcChPciPmonCtl3Addr       = 0x0E4
	XpfMcChPciPmonCtl2Addr       = 0x0E0
	XpfMcChPciPmonCtl1Addr       = 0x0DC
	XpfMcChPciPmonCtl0Addr       = 0x0D8
	KnxMcChPciPmonFixedCtlAddr   = 0xB44
	KnxMcChPciPmonCtl3Addr       = 0xB2C
	KnxMcChPciPmonCtl2Addr       = 0xB28
	KnxMcChPciPmonCtl1Addr       = 0xB24
	KnxMcChPciPmonCtl0Addr       = 0xB20
	XpfMcChPciPmonFixedCtrAddr   = 0x0D0
	XpfMcChPciPmonCtr3Addr       = 0x0B8
	XpfMcChPciPmonCtr2Addr       = 0x0B0
	XpfMcChPciPmonCtr1Addr       = 0x0A8
	XpfMcChPciPmonCtr0Addr       = 0x0A0
	KnxMcChPciPmonFixedCtrAddr   = 0xB3C
	KnxMcChPciPmonCtr3Addr       = 0xB18
	KnxMcChPciPmonCtr2Addr       = 0xB10
	KnxMcChPciPmonCtr1Addr       = 0xB08
	KnxMcChPciPmonCtr0Addr       = 0xB00
)

var registers map[string]int

func init() {
	registers = make(map[string]int)

	registers["JktivtMc0Ch0RegisterDevAddr"] = JktivtMc0Ch0RegisterDevAddr
	registers["JktivtMc0Ch1RegisterDevAddr"] = JktivtMc0Ch1RegisterDevAddr
	registers["JktivtMc0Ch2RegisterDevAddr"] = JktivtMc0Ch2RegisterDevAddr
	registers["JktivtMc0Ch3RegisterDevAddr"] = JktivtMc0Ch3RegisterDevAddr
	registers["JktivtMc0Ch0RegisterFuncAddr"] = JktivtMc0Ch0RegisterFuncAddr
	registers["JktivtMc0Ch1RegisterFuncAddr"] = JktivtMc0Ch1RegisterFuncAddr
	registers["JktivtMc0Ch2RegisterFuncAddr"] = JktivtMc0Ch2RegisterFuncAddr
	registers["JktivtMc0Ch3RegisterFuncAddr"] = JktivtMc0Ch3RegisterFuncAddr
	registers["JktivtMc1Ch0RegisterDevAddr"] = JktivtMc1Ch0RegisterDevAddr
	registers["JktivtMc1Ch1RegisterDevAddr"] = JktivtMc1Ch1RegisterDevAddr
	registers["JktivtMc1Ch2RegisterDevAddr"] = JktivtMc1Ch2RegisterDevAddr
	registers["JktivtMc1Ch3RegisterDevAddr"] = JktivtMc1Ch3RegisterDevAddr
	registers["JktivtMc1Ch0RegisterFuncAddr"] = JktivtMc1Ch0RegisterFuncAddr
	registers["JktivtMc1Ch1RegisterFuncAddr"] = JktivtMc1Ch1RegisterFuncAddr
	registers["JktivtMc1Ch2RegisterFuncAddr"] = JktivtMc1Ch2RegisterFuncAddr
	registers["JktivtMc1Ch3RegisterFuncAddr"] = JktivtMc1Ch3RegisterFuncAddr
	registers["HsxMc0Ch0RegisterDevAddr"] = HsxMc0Ch0RegisterDevAddr
	registers["HsxMc0Ch1RegisterDevAddr"] = HsxMc0Ch1RegisterDevAddr
	registers["HsxMc0Ch2RegisterDevAddr"] = HsxMc0Ch2RegisterDevAddr
	registers["HsxMc0Ch3RegisterDevAddr"] = HsxMc0Ch3RegisterDevAddr
	registers["HsxMc0Ch0RegisterFuncAddr"] = HsxMc0Ch0RegisterFuncAddr
	registers["HsxMc0Ch1RegisterFuncAddr"] = HsxMc0Ch1RegisterFuncAddr
	registers["HsxMc0Ch2RegisterFuncAddr"] = HsxMc0Ch2RegisterFuncAddr
	registers["HsxMc0Ch3RegisterFuncAddr"] = HsxMc0Ch3RegisterFuncAddr
	registers["HsxMc1Ch0RegisterDevAddr"] = HsxMc1Ch0RegisterDevAddr
	registers["HsxMc1Ch1RegisterDevAddr"] = HsxMc1Ch1RegisterDevAddr
	registers["HsxMc1Ch2RegisterDevAddr"] = HsxMc1Ch2RegisterDevAddr
	registers["HsxMc1Ch3RegisterDevAddr"] = HsxMc1Ch3RegisterDevAddr
	registers["HsxMc1Ch0RegisterFuncAddr"] = HsxMc1Ch0RegisterFuncAddr
	registers["HsxMc1Ch1RegisterFuncAddr"] = HsxMc1Ch1RegisterFuncAddr
	registers["HsxMc1Ch2RegisterFuncAddr"] = HsxMc1Ch2RegisterFuncAddr
	registers["HsxMc1Ch3RegisterFuncAddr"] = HsxMc1Ch3RegisterFuncAddr
	registers["KnlMc0Ch0RegisterDevAddr"] = KnlMc0Ch0RegisterDevAddr
	registers["KnlMc0Ch1RegisterDevAddr"] = KnlMc0Ch1RegisterDevAddr
	registers["KnlMc0Ch2RegisterDevAddr"] = KnlMc0Ch2RegisterDevAddr
	registers["KnlMc0Ch0RegisterFuncAddr"] = KnlMc0Ch0RegisterFuncAddr
	registers["KnlMc0Ch1RegisterFuncAddr"] = KnlMc0Ch1RegisterFuncAddr
	registers["KnlMc0Ch2RegisterFuncAddr"] = KnlMc0Ch2RegisterFuncAddr
	registers["SkxMc0Ch0RegisterDevAddr"] = SkxMc0Ch0RegisterDevAddr
	registers["SkxMc0Ch1RegisterDevAddr"] = SkxMc0Ch1RegisterDevAddr
	registers["SkxMc0Ch2RegisterDevAddr"] = SkxMc0Ch2RegisterDevAddr
	registers["SkxMc0Ch3RegisterDevAddr"] = SkxMc0Ch3RegisterDevAddr
	registers["SkxMc0Ch0RegisterFuncAddr"] = SkxMc0Ch0RegisterFuncAddr
	registers["SkxMc0Ch1RegisterFuncAddr"] = SkxMc0Ch1RegisterFuncAddr
	registers["SkxMc0Ch2RegisterFuncAddr"] = SkxMc0Ch2RegisterFuncAddr
	registers["SkxMc0Ch3RegisterFuncAddr"] = SkxMc0Ch3RegisterFuncAddr
	registers["SkxMc1Ch0RegisterDevAddr"] = SkxMc1Ch0RegisterDevAddr
	registers["SkxMc1Ch1RegisterDevAddr"] = SkxMc1Ch1RegisterDevAddr
	registers["SkxMc1Ch2RegisterDevAddr"] = SkxMc1Ch2RegisterDevAddr
	registers["SkxMc1Ch3RegisterDevAddr"] = SkxMc1Ch3RegisterDevAddr
	registers["SkxMc1Ch0RegisterFuncAddr"] = SkxMc1Ch0RegisterFuncAddr
	registers["SkxMc1Ch1RegisterFuncAddr"] = SkxMc1Ch1RegisterFuncAddr
	registers["SkxMc1Ch2RegisterFuncAddr"] = SkxMc1Ch2RegisterFuncAddr
	registers["SkxMc1Ch3RegisterFuncAddr"] = SkxMc1Ch3RegisterFuncAddr
	registers["KnlMc1Ch0RegisterDevAddr"] = KnlMc1Ch0RegisterDevAddr
	registers["KnlMc1Ch1RegisterDevAddr"] = KnlMc1Ch1RegisterDevAddr
	registers["KnlMc1Ch2RegisterDevAddr"] = KnlMc1Ch2RegisterDevAddr
	registers["KnlMc1Ch0RegisterFuncAddr"] = KnlMc1Ch0RegisterFuncAddr
	registers["KnlMc1Ch1RegisterFuncAddr"] = KnlMc1Ch1RegisterFuncAddr
	registers["KnlMc1Ch2RegisterFuncAddr"] = KnlMc1Ch2RegisterFuncAddr
	registers["XpfMcChPciPmonBoxCtlAddr"] = XpfMcChPciPmonBoxCtlAddr
	registers["KnxMcChPciPmonBoxCtlAddr"] = KnxMcChPciPmonBoxCtlAddr
	registers["XpfMcChPciPmonFixedCtlAddr"] = XpfMcChPciPmonFixedCtlAddr
	registers["XpfMcChPciPmonCtl3Addr"] = XpfMcChPciPmonCtl3Addr
	registers["XpfMcChPciPmonCtl2Addr"] = XpfMcChPciPmonCtl2Addr
	registers["XpfMcChPciPmonCtl1Addr"] = XpfMcChPciPmonCtl1Addr
	registers["XpfMcChPciPmonCtl0Addr"] = XpfMcChPciPmonCtl0Addr
	registers["KnxMcChPciPmonFixedCtlAddr"] = KnxMcChPciPmonFixedCtlAddr
	registers["KnxMcChPciPmonCtl3Addr"] = KnxMcChPciPmonCtl3Addr
	registers["KnxMcChPciPmonCtl2Addr"] = KnxMcChPciPmonCtl2Addr
	registers["KnxMcChPciPmonCtl1Addr"] = KnxMcChPciPmonCtl1Addr
	registers["KnxMcChPciPmonCtl0Addr"] = KnxMcChPciPmonCtl0Addr
	registers["XpfMcChPciPmonFixedCtrAddr"] = XpfMcChPciPmonFixedCtrAddr
	registers["XpfMcChPciPmonCtr3Addr"] = XpfMcChPciPmonCtr3Addr
	registers["XpfMcChPciPmonCtr2Addr"] = XpfMcChPciPmonCtr2Addr
	registers["XpfMcChPciPmonCtr1Addr"] = XpfMcChPciPmonCtr1Addr
	registers["XpfMcChPciPmonCtr0Addr"] = XpfMcChPciPmonCtr0Addr
	registers["KnxMcChPciPmonFixedCtrAddr"] = KnxMcChPciPmonFixedCtrAddr
	registers["KnxMcChPciPmonCtr3Addr"] = KnxMcChPciPmonCtr3Addr
	registers["KnxMcChPciPmonCtr2Addr"] = KnxMcChPciPmonCtr2Addr
	registers["KnxMcChPciPmonCtr1Addr"] = KnxMcChPciPmonCtr1Addr
	registers["KnxMcChPciPmonCtr0Addr"] = KnxMcChPciPmonCtr0Addr
}
