package pcm

const (
	NehalemEp       = int64(26)
	Nehalem         = int64(30)
	Atom            = int64(28)
	Atom2           = int64(53)
	Centerton       = int64(54)
	Baytrail        = int64(55)
	Avoton          = int64(77)
	Cherrytrail     = int64(76)
	ApolloLake      = int64(92)
	Denverton       = int64(95)
	Clarkdale       = int64(37)
	WestmereEp      = int64(44)
	NehalemEx       = int64(46)
	WestmereEx      = int64(47)
	SandyBridge     = int64(42)
	Jaketown        = int64(45)
	IvyBridge       = int64(58)
	Haswell         = int64(60)
	HaswellUlt      = int64(69)
	Haswell2        = int64(70)
	Ivytown         = int64(62)
	Haswellx        = int64(63)
	Broadwell       = int64(61)
	BroadwellXeonE3 = int64(71)
	BdxDe           = int64(86)
	SklUy           = int64(78)
	Kbl             = int64(158)
	Kbl1            = int64(142)
	Icl             = int64(126)
	Bdx             = int64(79)
	Knl             = int64(87)
	Skl             = int64(94)
	Skx             = int64(85)
	// END_OF_MODEL_LIST = 0x0ffff
)

var (
	supportedModels = make(map[int64]struct{})
)

func init() {
	s := struct{}{}
	supportedModels[NehalemEp] = s
	supportedModels[Nehalem] = s
	supportedModels[Atom] = s
	supportedModels[Atom2] = s
	supportedModels[Centerton] = s
	supportedModels[Baytrail] = s
	supportedModels[Avoton] = s
	supportedModels[Cherrytrail] = s
	supportedModels[ApolloLake] = s
	supportedModels[Denverton] = s
	supportedModels[Clarkdale] = s
	supportedModels[WestmereEp] = s
	supportedModels[NehalemEp] = s
	supportedModels[WestmereEx] = s
	supportedModels[SandyBridge] = s
	supportedModels[Jaketown] = s
	supportedModels[IvyBridge] = s
	supportedModels[Haswell] = s
	supportedModels[HaswellUlt] = s
	supportedModels[Haswell2] = s
	supportedModels[Ivytown] = s
	supportedModels[Haswellx] = s
	supportedModels[Broadwell] = s
	supportedModels[BroadwellXeonE3] = s
	supportedModels[BdxDe] = s
	supportedModels[SklUy] = s
	supportedModels[Kbl] = s
	supportedModels[Kbl1] = s
	supportedModels[Icl] = s
	supportedModels[Bdx] = s
	// supportedModels[KNL] = s  - disable for now
	supportedModels[Skl] = s
	supportedModels[Skx] = s
	// supportedModels[END_OF_MODEL_LIST] = s
}

func isSupported(model int64) bool {
	_, ok := supportedModels[model]
	return ok
}

func hasPCICFGUncore(model int64) bool {
	if model == Jaketown ||
		model == Ivytown ||
		model == Haswellx ||
		model == BdxDe ||
		model == Skx ||
		model == Bdx ||
		model == Knl {
		return true
	}
	return false
}

func hasClientMCCounters(model int64) bool {
	if model == SandyBridge ||
		model == IvyBridge ||
		model == Haswell ||
		model == Broadwell ||
		model == Skl ||
		model == Kbl ||
		model == Icl {

		return true
	}

	return false
}
