package pcm

const (
	UncPmonUnitCtlFrz         = 1 << 8
	UncPmonUnitCtlFrzEn       = 1 << 16
	UncPmonUnitCtlRsv         = ((1 << 16) + (1 << 17))
	UncPmonUnitCtlRstCounters = 1 << 1
)

const (
	McChPciPmonFixedCtlEn  = 1 << 22
	McChPciPmonFixedCtlRst = 1 << 19
	McChPciPmonCtlEn       = 1 << 22
)

type imcUncorePMU struct {
	UnitControl         *hwRegister32
	CounterControls     []*hwRegister32
	CounterValues       []*hwRegister64
	FixedCounterControl *hwRegister32
	FixedCounterValue   *hwRegister64
}

func (imcpmu *imcUncorePMU) initFreeze(extra uint32) error {
	// enabel freeze
	err := imcpmu.UnitControl.Write(extra)
	if err != nil {
		return err
	}
	// freeze
	return imcpmu.UnitControl.Write(extra + UncPmonUnitCtlFrz)
}

func (imcpmu *imcUncorePMU) resetUnfreeze(extra uint32) error {
	// enabel freeze
	err := imcpmu.UnitControl.Write(extra + UncPmonUnitCtlFrz + UncPmonUnitCtlRstCounters)
	if err != nil {
		return err
	}
	// freeze
	return imcpmu.UnitControl.Write(extra)
}

func (imcpmu *imcUncorePMU) cleanup() error {
	for i := 0; i < MaxCounters; i++ {
		err := imcpmu.CounterControls[i].Write(0)
		if err != nil {
			return err
		}
	}
	err := imcpmu.UnitControl.Write(0)
	if err != nil {
		return err
	}
	return imcpmu.FixedCounterControl.Write(0)
}
