package balancer

import (
	"context"
	"os/exec"
	"syscall"
)

func New(bin, cfg string, args ...string) *Balancer {
	return &Balancer{
		Cmd: exec.Command(bin, append(args, cfg)...),
	}
}

// Balancer is a wrapper around balancer executable
type Balancer struct {
	*exec.Cmd
	waitDone chan struct{}
}

func (b *Balancer) Start(ctx context.Context) error {
	if err := b.Cmd.Start(); err != nil {
		return err
	}
	b.waitDone = make(chan struct{})
	go func() {
		select {
		case <-ctx.Done():
			if b.Process != nil {
				_ = b.Process.Signal(syscall.SIGTERM)
			}
		case <-b.waitDone:
		}
	}()
	return nil
}

func (b *Balancer) Wait() error {
	err := b.Cmd.Wait()
	if b.waitDone != nil {
		close(b.waitDone)
	}
	return err
}

func (b *Balancer) Run(ctx context.Context) error {
	if err := b.Start(ctx); err != nil {
		return err
	}
	return b.Wait()
}
