package config

import (
	"net"
)

type rawAddr net.TCPAddr

func (a *rawAddr) UnmarshalYAML(unmarshal func(interface{}) error) error {
	var tmp struct {
		IP   string `yaml:"ip"`
		Port uint16 `yaml:"port"`
	}
	if err := unmarshal(&tmp); err != nil {
		return err
	}
	if tmp.IP != "" {
		a.IP = net.ParseIP(tmp.IP)
		if a.IP == nil {
			return &ParseError{
				what: tmp.IP,
				as:   "IP",
			}
		}
	}
	if tmp.Port != 0 {
		a.Port = int(tmp.Port)
	}
	return nil
}
