package config

// Balancers is a helper structure for map of balancers' ids to its configs.
type Balancers map[string]*Balancer

// UnmarshalYAML performs unmarshalling and sets all Balancer.ID fields to
// corresponding keys in YAML
func (c *Balancers) UnmarshalYAML(unmarshal func(interface{}) error) error {
	type raw Balancers
	tmp := raw(*c)
	if err := unmarshal(&tmp); err != nil {
		return err
	}
	*c = Balancers(tmp)
	for id := range *c {
		if (*c)[id] == nil {
			(*c)[id] = &DefaultBalancer
		}
		(*c)[id].ID = id
	}
	return nil
}

var DefaultBalancer = Balancer{
	Spec: DefaultSpec,
}

// Balancer is a structure for .balancers[<id>]
type Balancer struct {
	ID            string        `yaml:"-" valid:"required"`
	LocalEndpoint LocalEndpoint `yaml:"local_endpoint"`
	Spec          Spec          `yaml:"spec"`
}

func (b *Balancer) UnmarshalYAML(unmarshal func(interface{}) error) error {
	type raw Balancer
	tmp := raw(DefaultBalancer)
	if err := unmarshal(&tmp); err != nil {
		return err
	}
	*b = Balancer(tmp)
	return nil
}
