package config

import (
	"fmt"
	"time"
)

// Duration is a wrapper around time.Duration which provides
// methods for unmarshalling and encoding to balancer Lua config format.
type Duration time.Duration

func (d *Duration) UnmarshalYAML(unmarshal func(interface{}) error) error {
	var tmp string
	if err := unmarshal(&tmp); err != nil {
		return err
	}
	dd, err := time.ParseDuration(tmp)
	if err != nil {
		return &ParseError{
			what: tmp,
			as:   "Duration",
			err:  err,
		}
	}
	*d = Duration(dd)
	return nil
}

func (d Duration) MarshalLua() string {
	return fmt.Sprintf("%dms", time.Duration(d).Milliseconds())
}

func (d Duration) String() string {
	return time.Duration(d).String()
}
