package config

import (
	"a.yandex-team.ru/library/go/valid"
)

type Dynamic struct {
	MaxPessimizedShare    *float32  `yaml:"max_pessimized_share" valid:"required"`
	MinPessimizationCoeff *float32  `yaml:"min_pessimization_coeff" valid:"required"`
	WeightIncreaseStep    *float32  `yaml:"weight_increase_step" valid:"required"`
	HistoryInterval       *Duration `yaml:"history_interval" valid:"required"`
	BackendsName          string    `yaml:"backends_name" valid:"required"`
	TCPCheck              *bool     `yaml:"tcp_check" valid:"omitempty"`

	// if Active is not nil, balancer will use active checks
	// to determine whether backend is alive (HTTP only)
	Active *Active `yaml:"active" valid:"omitempty"`
}

func (d *Dynamic) Validate(_ *valid.ValidationCtx) (bool, error) {
	if d == nil {
		return false, Required("")
	}
	return true, nil
}

type Active struct {
	UseBackendWeight         *bool     `yaml:"use_backend_weight" valid:"required"`
	WeightNormalizationCoeff *float32  `yaml:"weight_normalization_coeff" valid:"required"`
	Request                  string    `yaml:"request" valid:"required"`
	Delay                    *Duration `yaml:"delay" valid:"required"`
}
