package config

import "fmt"

type RequiredFieldIsEmpty string

func (e RequiredFieldIsEmpty) Error() string {
	return fmt.Sprintf("field %q should not be empty", string(e))
}

type DuplicateFound struct {
	where string
	what  interface{}
}

func (e *DuplicateFound) Error() string {
	return fmt.Sprintf("%q should be unique, but duplicate was found for %q", e.where, e.what)
}

type ParseError struct {
	what string
	as   string
	err  error
}

func (e *ParseError) Error() string {
	return fmt.Sprintf("unable to parse %q as %s: %s", e.what, e.as, e.err)
}

func (e *ParseError) Unwrap() error {
	return e.err
}
