package config

import (
	"net"
)

// LocalEndpoint is a structure for .balancers[<id>].local_endpoint
type LocalEndpoint struct {
	Addr net.TCPAddr `valid:"required=IP+Port"`
	FQDN string
}

func (le *LocalEndpoint) UnmarshalYAML(unmarshal func(interface{}) error) error {
	var tmp struct {
		RawAddr rawAddr `yaml:",inline"`
		FQDN    string  `yaml:"fqdn"`
	}
	if err := unmarshal(&tmp); err != nil {
		return err
	}
	*le = LocalEndpoint{
		Addr: net.TCPAddr(tmp.RawAddr),
		FQDN: tmp.FQDN,
	}
	return nil
}
