package config

import (
	"io/ioutil"
	"net"
	"testing"
	"text/template"

	"github.com/stretchr/testify/require"
)

func TestLuaTemplate(t *testing.T) {
	_, err := template.New("config").Parse(luaConfigTmpl)
	require.NoError(t, err)
	tests := []struct {
		name    string
		cfg     Config
		wantErr bool
	}{
		{
			name:    "empty config",
			cfg:     Config{},
			wantErr: false,
		},
		{
			name: "",
			cfg: Config{
				StateDirectory: "",
				UniStat: UniStat{
					Addr: net.TCPAddr{
						IP:   nil,
						Port: 0,
						Zone: "",
					},
				},
				ServiceDiscovery: ServiceDiscovery{},
				Balancers:        nil,
			},
			wantErr: false,
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			if err := tt.cfg.genLua(ioutil.Discard); tt.wantErr {
				require.Error(t, err)
			} else {
				require.NoError(t, err)
			}
		})
	}
}
