package config

import (
	"time"

	"a.yandex-team.ru/library/go/valid"
)

var DefaultServiceDiscovery = ServiceDiscovery{
	Host:            "sd.yandex.net",
	Port:            uint16(8080),
	UpdateFrequency: Duration(5 * time.Minute),
	ConnectTimeout:  Duration(60 * time.Millisecond),
	RequestTimeout:  Duration(500 * time.Millisecond),
	CacheDir:        "./sd_cache",
	Log:             "/logs/sd_log",
}

// ServiceDiscovery is a structure for .service_discovery
type ServiceDiscovery struct {
	// we do not need net.TCPAddr here as
	// we use this only as strings to generate lua
	Host            string   `yaml:"host"`
	Port            uint16   `yaml:"port"`
	UpdateFrequency Duration `yaml:"update_frequency"`
	ConnectTimeout  Duration `yaml:"connect_timeout"`
	RequestTimeout  Duration `yaml:"request_timeout"`
	ClientName      string   `yaml:"client_name" valid:"required"`
	CacheDir        string   `yaml:"cache_dir"`
	Log             string   `yaml:"log"`
}

func (sd *ServiceDiscovery) Validate(_ *valid.ValidationCtx) (bool, error) {
	if sd == nil {
		return false, Required("")
	}
	return true, nil
}

func (sd *ServiceDiscovery) UnmarshalYAML(unmarshal func(interface{}) error) error {
	type rawSD ServiceDiscovery
	tmp := rawSD(DefaultServiceDiscovery)
	if err := unmarshal(&tmp); err != nil {
		return err
	}
	*sd = ServiceDiscovery(tmp)
	return nil
}
