package config

import "time"

var DefaultSpec = Spec{
	Attempts:       1,
	BackendTimeout: Duration(24 * time.Hour),
	ConnectTimeout: Duration(100 * time.Millisecond),
}

type YPEndpointSet struct {
	Cluster string
	ID      string
}

// Spec is a structure for .balancers[<id>].spec
type Spec struct {
	Attempts uint64 `yaml:"attempts"`

	YPEndpointSets []YPEndpointSet `yaml:"yp_endpointsets" valid:"required"`

	BackendTimeout Duration `yaml:"backend_timeout"`
	ConnectTimeout Duration `yaml:"connect_timeout"`

	Dynamic *Dynamic `yaml:"dynamic"`
}

func (s *Spec) UnmarshalYAML(unmarhsal func(interface{}) error) error {
	type rawSpec Spec
	tmp := rawSpec(DefaultSpec)
	if err := unmarhsal(&tmp); err != nil {
		return err
	}
	*s = Spec(tmp)
	return nil
}
