package config

import "net"

var DefaultUniStat = UniStat{
	Addr: net.TCPAddr{
		IP:   net.IPv6unspecified,
		Port: 8765,
	},
}

// UniStat is a structure for unistat
type UniStat struct {
	Addr net.TCPAddr
}

// Unistat can be unmarshalled from YAML.
// There is no need to set defaults externally as unistat makes it by itself.
func (u *UniStat) UnmarshalYAML(unmarshal func(interface{}) error) error {
	tmp := struct {
		RawAddr rawAddr `yaml:",inline"`
	}{RawAddr: rawAddr(DefaultUniStat.Addr)}
	if err := unmarshal(&tmp); err != nil {
		return err
	}
	u.Addr = net.TCPAddr(tmp.RawAddr)
	return nil
}
