package unistats

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestUniStats_Merge(t *testing.T) {
	tests := []struct {
		name string
		s    UniStats
		with UniStats
		want UniStats
	}{
		{
			name: "nil receiver",
			s:    nil,
			with: UniStats{
				{"a", 1},
				{"b", 2},
			},
			want: UniStats{
				{"a", 1},
				{"b", 2},
			},
		},
		{
			name: "empty arg",
			s: UniStats{
				{"a", 1},
				{"b", 2},
			},
			with: nil,
			want: UniStats{
				{"a", 1},
				{"b", 2},
			},
		},
		{
			name: "different signals",
			s: UniStats{
				{"a", 1},
				{"c", 3},
			},
			with: UniStats{
				{"b", 2},
				{"d", 4},
			},
			want: UniStats{
				{"a", 1},
				{"c", 3},
				{"b", 2},
				{"d", 4},
			},
		},
		{
			name: "no ignore repeated signals",
			s: UniStats{
				{"a", 1},
				{"b", 2},
			},
			with: UniStats{
				{"c", 3},
				{"a", 4},
			},
			want: UniStats{
				{"a", 1},
				{"b", 2},
				{"c", 3},
				{"a", 4},
			},
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			require.Equal(t, tt.s.Merge(tt.with), tt.want)
		})
	}
}
