package watch

import (
	"context"
	"encoding/json"
	"net/http"
	"net/http/httptest"
	"testing"

	"a.yandex-team.ru/infra/goxcart/pkg/unistats"
	"github.com/stretchr/testify/require"
)

func TestUnistat_Update(t *testing.T) {
	serverResp := unistats.UniStats{
		{"a", float64(0)}, // json.Unmarshal decodes all numbers to float64 if node is interface{}
	}
	ts := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		if err := json.NewEncoder(w).Encode(serverResp); err != nil {
			t.Errorf("unable to encode json: %s", err)
		}
	}))
	defer ts.Close()
	tests := []struct {
		name         string
		URL          string
		wantErr      bool
		wantUnistats unistats.UniStats
	}{
		{
			name:         "empty URL",
			URL:          "",
			wantErr:      true,
			wantUnistats: nil, // want to it drop stats
		},
		{
			name:         "not URL",
			URL:          "abc",
			wantErr:      true,
			wantUnistats: nil, // want to it drop stats
		},
		{
			name:         "update",
			URL:          ts.URL,
			wantErr:      false,
			wantUnistats: serverResp,
		},
	}
	for i, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			s := &Unistat{
				URL: tt.URL,
			}
			if err := s.Update(context.Background()); tt.wantErr {
				require.Error(t, err)
				return
			} else {
				require.NoError(t, err)
			}
			require.Equal(t, s.Unistats(), tt.wantUnistats)
		})
		serverResp[0][1] = float64(i) // update server response
	}
}
