#!/bin/sh

set -e 

SELF_PATH="$(realpath "$0")"
SCRIPT_PATH="$(dirname "$SELF_PATH")"
ROOT_PATH="$(realpath "$SCRIPT_PATH/..")"
BUILDDIR="$ROOT_PATH/build/doit"

rm -rf "$BUILDDIR"
mkdir -p "$BUILDDIR"

cd $ROOT_PATH

rm -rf ./doit

hg clone https://bitbucket.org/schettino72/doit "$BUILDDIR"
hg -R "$BUILDDIR" up 0.17.0

sed -i -e "s/pkgs.append('doit')/pkgs = ('doit', 'py')/" "$BUILDDIR/genstandalone.py"

python3.2 "$BUILDDIR/genstandalone.py"

rm -rf "$BUILDDIR"
