import os
import functools

try:
    from setuptools import setup
    from pkg_resources import require  # noqa
except ImportError:
    import sys
    print >> sys.stderr, 'Please install distribute from PyPi first.'
    exit(1)


NS_PKG_STUB = '__import__("pkg_resources").declare_namespace(__name__)'


from setuptools.command.bdist_egg import bdist_egg, walk_egg, log
from setuptools.command import easy_install

# Patch script header getter to add system path updater.
get_script_header_func = easy_install.get_script_header


@functools.wraps(easy_install.get_script_header)
def custom_script_header(*args, **kwargs):
    hdr = get_script_header_func(*args, **kwargs)
    return hdr + """
# Ok, let's check for PYTHONPATH correctly provided, otherwise initialize it on our own.
import os
import sys

bindir = os.sep + 'bin'
libdir = os.path.join(os.path.dirname(os.path.realpath(sys.argv[0])), 'lib')
while bindir in libdir:
    libdir = os.path.normpath(os.path.join(libdir, '..', '..', 'lib'))
if not filter(lambda x: x.startswith(libdir), sys.path):
    sys.path.append(libdir)
    \n"""
easy_install.get_script_header = custom_script_header


class mbdist_egg(bdist_egg):  # noqa
    def make_init_files(self):
        """Create missing package __init__ files"""
        init_files = []
        for base, dirs, files in walk_egg(self.bdist_dir):
            if base == self.bdist_dir:
                # don't put an __init__ in the root
                continue

            if '__init__.py' not in files:
                pkg = base[len(self.bdist_dir) + 1:].replace(os.sep, '.')
                if self.distribution.has_contents_for(pkg):
                    log.warn("Creating missing __init__.py for %s", pkg)
                    filename = os.path.join(base, '__init__.py')
                    if not self.dry_run:
                        with open(filename, 'w') as f:
                            f.write(NS_PKG_STUB)
                    init_files.append(filename)

        return init_files


def plugin_script(name, module_name=None):
    return 'plugin__%s = ya.skynet.services.heartbeatclient.plugins.%s:main' % (
        name.replace('.', '_'),
        module_name if module_name else name
    )


setup(
    name='skynet-heartbeat-client-service',
    version='0.1',
    description='Skynet HeartBeat Client Service',
    zip_safe=True,
    install_requires=[
        'apsw',
        'python-daemon',
        'PyYAML',
        'msgpack-python',
        'faulthandler',
    ],
    packages=[
        'ya.skynet.services.heartbeatclient',
        'ya.skynet.services.heartbeatclient.daemon',
        'ya.skynet.services.heartbeatclient.plugins',
        'ya.skynet.services.heartbeatclient.plugins.monitoring',
        'ya.skynet.services.heartbeatclient.plugins.metrics',
        'ya.skynet.services.heartbeatclient.plugins.sre',
        'ya.skynet.services.heartbeatclient.rpc',
        'ya.skynet.services.heartbeatclient.utils',
    ],
    package_dir={'ya.skynet.services.heartbeatclient': 'src'},
    namespace_packages=['ya'],
    entry_points={
        'console_scripts': [
            'daemon = ya.skynet.services.heartbeatclient.daemon.daemon:main',
            'check = ya.skynet.services.heartbeatclient.daemon.check:main',
            'stop = ya.skynet.services.heartbeatclient.daemon.stop:main',
            plugin_script('pinger2'),
            plugin_script('skyinfo'),
            plugin_script('hostinfo'),
            plugin_script('softinfo'),
            plugin_script('shardsize'),
            plugin_script('shardstate'),
            plugin_script('shardstateV3'),
            plugin_script('instancestateV3'),
            plugin_script('instancestateV4'),
            plugin_script('goskyversion'),
            plugin_script('monitoring_cqueue', 'monitoring.cqueue'),
            plugin_script('metrics_cqueue', 'metrics.cqueue'),
            plugin_script('metrics_cqrestarts', 'metrics.cqrestarts'),
            plugin_script('metrics_resolver', 'metrics.resolver'),
            plugin_script('instanceusage'),
            plugin_script('memleak'),
            plugin_script('hwdata'),
            plugin_script('unworking'),
            plugin_script('lldpinfo'),
            plugin_script('instanceusagev2', 'sre.instanceusagev2'),
            plugin_script('instanceusagev2_infreq', 'sre.instanceusagev2_infreq'),
            plugin_script('skystat'),
            plugin_script('oopsstat'),
            plugin_script('issinfo'),
            plugin_script('who'),
            plugin_script('last'),
            plugin_script('dutop'),
        ]
    },
    cmdclass={'bdist_egg': mbdist_egg}
)
