CREATE TABLE "report" (
  "id"          INTEGER PRIMARY KEY,  -- Actually, an alias to "rowid".
  "type"        TEXT    NOT NULL, -- Report type (name).
  "added"       REAL    NOT NULL, -- Timestamp. A moment, when the report has been generated and placed into the queue.
  "updated"     REAL,             -- Timestamp. Last report actualization date.
  "sent"        REAL,             -- Timestamp. A moment, when the report has been sent.
  "expires"     REAL    NOT NULL, -- Timestamp. A moment, when the report will become expired.
  "data"        BLOB    NOT NULL, -- Report content.
  "format"      TEXT    NOT NULL, -- Report format. Currently only 'msgpack' supported.
  "compression" TEXT,             -- Can be 'zip', 'bz2' or NULL
  "checksum"    TEXT    NOT NULL, -- SHA1 checksum of the report content. Used to avoid sending of
                                  -- the similar reports.
  "attempts"    INTEGER NOT NULL DEFAULT 0, -- Amount of send attempts.
  "state"       INTEGER NOT NULL DEFAULT 0  -- Enumerator. `0` means the report wasn't sent at all,
                                            -- `1` - the report is sending right now,
                                            -- `2` - the report has been sent successfully.
);

CREATE INDEX "report_state" ON "report" ("state" ASC);
CREATE INDEX "report_expires" ON "report" ("expires" ASC);
CREATE INDEX "report_type_state" ON "report" ("type" ASC, "state" ASC);
