from __future__ import absolute_import
from api.config import Config
import os


def make_connection(appdir, rundir):
    def _make_connection(master=False, appdir=appdir, rundir=rundir):
        return (masterServer if master else server)(gevent=Config.useGevent, appdir=appdir, rundir=rundir)

    return _make_connection


def server(gevent=False, cfg=None, socket_path=None, appdir='', rundir=None):
    if not gevent:
        from .rpc.client import RPCClient
    else:
        from .rpc.client import RPCClientGevent as RPCClient

    if cfg is None:
        from .daemon import config
        cfg = config.loadConfig(overrides={'AppPath': appdir}).rpc

    if socket_path is None:
        if rundir is None:
            from api.srvmngr import getRoot
            rundir = os.path.join(getRoot(), 'var', 'heartbeat-client')
        socket_path = os.path.join(rundir, 'socket')

    try:
        return RPCClient(socket_path, None, cfg=cfg)
    except:
        from kernel.util.errors import formatException
        print(formatException())
        raise


def masterServer(gevent=False, appdir='', rundir=''):
    if not gevent:
        from .rpc.client import RPCClient
    else:
        from .rpc.client import RPCClientGevent as RPCClient

    class _cfg(object):
        pass

    cfg = _cfg()
    cfg.connection_magic = 0x7F466786
    cfg.handshake_send_timeout = 10
    cfg.handshake_receive_timeout = 10
    cfg.uid_generation_tries = 10
    cfg.uid_generation_retry_sleep = 0.1
    cfg.uid_bits = 32
    cfg.client = _cfg()
    cfg.client.connect_timeout = 10
    cfg.client.socket_nodelay = False
    cfg.client.socket_receive_buffer = 131072
    cfg.client.socket_send_buffer = 131072
    cfg.client.idle_timeout = 10
    cfg.client.ping_tick_time = 10
    cfg.client.ping_wait_time = 10
    cfg.client.receive_buffer = 16384
    cfg.client.job_registration_timeout = 20

    try:
        return RPCClient('heartbeat.yandex-team.ru', 10023, cfg=cfg)
    except:
        from kernel.util.errors import formatException

        print(formatException())
        raise
