from __future__ import absolute_import
import time

import msgpack
import py

from api.cms import Registry

CACHE_VERSION = 1


def getHostList(itag, cacheTime, rundir):
    cacheFile = py.path.local(rundir).join('%s.cache' % itag)
    cacheFile.dirpath().ensure(dir=1)
    try:
        mtime = cacheFile.stat().mtime
    except:
        mtime = 0

    try:
        assert (time.time() - mtime) < cacheTime
        version, hostnamesPool = msgpack.loads(cacheFile.read(mode='rb'))
        assert version == CACHE_VERSION
        assert len(hostnamesPool) > 0
    except Exception:
        cms = Registry.nativeInterface()
        filters = {'conf': 'HEAD', 'instanceTagName': itag}
        hostnamesPool = [x['host'] for x in cms.listSearchInstances(filters)]
        cacheFile.write(msgpack.dumps((CACHE_VERSION, hostnamesPool)), mode='wb')

    return hostnamesPool
